/*$T ini..c GC 1.136 04/23/02 19:43:44 */

/* This is the INI routines, which load read and right INI keys. */
#include "globals.h"

/* Define gloabal variables, extern in globals.h */
TCHAR	szPath[MAX_PATH];				/* Used to hold path locations */
char	lpIniFileName[] = "gen_att.ini";	/* self-explanatory */
char	lpIniFileNameAndPath[256];		/* storage area for ini file name + path */
char	lpIniSection[64];				/* storage area for section name */
char	lpIniKeyName[128];				/* storage area for key name */
char	lpIniKeyData[1024];				/* storage area for data found in, or written to keys */
INT		INI_KEY_INTEGER = 0;			/* storage area for integer value */
INT		DIALOGKEY = 0;
DWORD	INI_DATA_BUFFER_SIZE = 1024;	/* size of destination buffer above (lpIniKeyData) */
char	lpIniDefaultString[] = "Not Defined";
char	*p; /* used in getting the ini file path */

/*
 =======================================================================================================================
    Used to read and write INI Data.
 =======================================================================================================================
 */
BOOL ReadWriteIniData(LPSTR lpIniSection, LPSTR lpIniKeyName, INT ACTION)
{
	if(ACTION == READ_STRING)
	{
		GetPrivateProfileString
		(
			lpIniSection,		/* points to section name */
			lpIniKeyName,		/* points to key name */
			lpIniDefaultString, /* points to default string */
			lpIniKeyData,		/* points to destination buffer */
			INI_DATA_BUFFER_SIZE,					/* size of destination buffer */
			lpIniFileNameAndPath					/* points to ini file name */
		);
		return TRUE;
	}

	if(ACTION == WRITE_STRING)
	{
		WritePrivateProfileString
		(
			lpIniSection,							/* pointer to section name */
			lpIniKeyName,							/* pointer to key name */
			lpIniKeyData,							/* pointer to string to add */
			lpIniFileNameAndPath					/* pointer to ini file name */
		);
		return TRUE;
	}

	if(ACTION == READ_INTEGER)
	{
		INI_KEY_INTEGER = GetPrivateProfileInt
			(
				lpIniSection,						/* points to section name */
				lpIniKeyName,						/* points to key name */
				0,									/* return value if key name is not found */
				lpIniFileNameAndPath				/* points to ini file name */
			);
		return TRUE;
	}

	if(ACTION == WRITE_INTEGER)
	{
		strcpy(lpIniKeyData, "\0");					/* clear the storage area (more or less) */
		itoa(INI_KEY_INTEGER, lpIniKeyData, 10);	/* convert the integer value into a string before storing it as a
													 * string (below) */
		WritePrivateProfileString
		(
			lpIniSection,			/* pointer to section name */
			lpIniKeyName,			/* pointer to key name */
			lpIniKeyData,			/* pointer to string to add */
			lpIniFileNameAndPath	/* pointer to ini file name */
		);
		return TRUE;

		/* Note we can Get an integer OR string but we can only Write a string */
	}

	return FALSE;
}

/*
 =======================================================================================================================
    Gets the location of the file, and works out where the INI file is.
 =======================================================================================================================
 */
BOOL GetIniFilePath(VOID)
{
	/* First get the full path of the application (C:\DIR\DIR\APP.EXE) */
	GetModuleFileName(hInstance, lpIniFileNameAndPath, sizeof(lpIniFileNameAndPath));

	/*
	 * Then trim off the program name leaving just the path to the directory
	 * (C:\DIR\DIR\)
	 */
	p = lpIniFileNameAndPath;
	while(strchr(p, '\\'))
	{	/* while there are more separators */
		p = strchr(p, '\\');	/* point to next separator */
		p++;					/* point to char after last separator */
	}

	*p = '\0';					/* terminate string */

	/*
	 * lpIniFileNameAndPath now has the application's directory 
	 * append ini file name to the path (C:\DIR\DIR\initest.ini)
	 */
	strcat(lpIniFileNameAndPath, lpIniFileName);

	/*
	 * Thanks to Robert Mashlan's Windows programmer FAQ 
	 * for much of the above code (http://www.r2m.com/win-developer-FAQ/)
	 */
	return TRUE;
}
